# Generated Python Strategy for: PlayerA (meta)
# Run Index: 10
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run10_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for always_cooperate or similar patterns
    always_cooperate = (
        "always_cooperate" in opponent_code or
        "return 'c'" in opponent_code or
        "return c" in opponent_code or
        "return 'cooperate'" in opponent_code or
        "return cooperate" in opponent_code
    )
    
    # Check for always_defect or similar patterns
    always_defect = (
        "always_defect" in opponent_code or
        "return 'd'" in opponent_code or
        "return d" in opponent_code or
        "return 'defect'" in opponent_code or
        "return defect" in opponent_code
    )
    
    # Check for tit-for-tat or similar patterns
    tit_for_tat = (
        "tit_for_tat" in opponent_code or
        "tit-for-tat" in opponent_code or
        "return opp_history[-1]" in opponent_code or
        "return opp_history[-1]" in opponent_code.replace(" ", "")
    )
    
    # Check for random behavior
    is_random = (
        "random.choice" in opponent_code or
        "random.choose" in opponent_code or
        "random.randint" in opponent_code
    )
    
    # Check for code length (very short or very long)
    code_lines = opponent_program_code.splitlines()
    code_length = len(code_lines)
    is_short_code = code_length <= 5
    is_long_code = code_length > 50
    
    # Check for self-referential or meta-agent patterns
    is_meta_agent = (
        "opponent_program_code" in opponent_code or
        "make_internal_llm_call" in opponent_code
    )
    
    # Decision making based on heuristics
    if always_cooperate:
        return "C"  # Cooperate with always_cooperate
    elif always_defect:
        return "D"  # Defect against always_defect
    elif tit_for_tat:
        if not opp_history:
            return "C"  # First move: cooperate
        else:
            return opp_history[-1]  # Mirror opponent's last move
    elif is_random:
        if not opp_history:
            return "C"  # First move: cooperate
        else:
            # If opponent is random, defect if they defected last time
            return "D" if opp_history[-1] == "D" else "C"
    elif is_short_code:
        return "C"  # Assume simple strategies are cooperative
    elif is_long_code or is_meta_agent:
        return "D"  # Be cautious with complex or meta-agents
    else:
        # Fallback to Tit-for-Tat if no clear heuristic matches
        if not opp_history:
            return "C"
        else:
            return opp_history[-1]